/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.api.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.util.ColorUtil;

public class ColorSettings {
    public static final Codec<ColorSettings> CODEC = RecordCodecBuilder.create(seasonClientSettingsInstance -> seasonClientSettingsInstance.group((App)Codec.STRING.fieldOf("skyLightColor").forGetter(colorSettings -> colorSettings.skyLightColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.skyLightColor)), (App)Codec.DOUBLE.fieldOf("skyLightBlendStrength").orElse((Object)0.5).forGetter(colorSettings -> colorSettings.skyLightBlendStrength), (App)Codec.STRING.fieldOf("moonTextureColor").forGetter(colorSettings -> colorSettings.skyLightColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.skyLightColor)), (App)Codec.DOUBLE.fieldOf("moonTextureBlendStrength").orElse((Object)0.5).forGetter(colorSettings -> colorSettings.skyLightBlendStrength)).apply((Applicative)seasonClientSettingsInstance, ColorSettings::new));
    private final int skyLightColor;
    private final double skyLightBlendStrength;
    private final int moonTextureColor;
    private final double moonTextureBlendStrength;

    public ColorSettings(String skyLightHexColor, double skyLightBlendStrength, String moonTextureHexColor, double moonTextureBlendStrength) {
        this(ColorSettings.tryParseColor(skyLightHexColor), skyLightBlendStrength, ColorSettings.tryParseColor(moonTextureHexColor), moonTextureBlendStrength);
    }

    public ColorSettings(int skyLightColor, double skyLightBlendStrength, int moonTextureColor, double moonTextureBlendStrength) {
        this.skyLightColor = skyLightColor;
        this.skyLightBlendStrength = skyLightBlendStrength;
        this.moonTextureColor = moonTextureColor;
        this.moonTextureBlendStrength = moonTextureBlendStrength;
    }

    public static int tryParseColor(String input) {
        int result = Integer.MAX_VALUE;
        if (input.isEmpty()) {
            return result;
        }
        try {
            result = (int)Long.parseLong(input.replace("#", "").replace("0x", ""), 16);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getMoonTextureColor() {
        return this.moonTextureColor;
    }

    public Vector3f getGLMoonColor() {
        return ColorUtil.glColor(ColorUtil.unpack(this.moonTextureColor));
    }

    public double getMoonTextureBlendStrength() {
        return this.moonTextureBlendStrength;
    }

    public int getSkyLightColor() {
        return this.skyLightColor;
    }

    public Vector3f getGLSkyLightColor() {
        return ColorUtil.glColor(ColorUtil.unpack(this.skyLightColor));
    }

    public double getSkyLightBlendStrength() {
        return this.skyLightBlendStrength;
    }
}

